<?php

namespace BitPaySDK\Test\Exceptions;

use BitPaySDK\Exceptions\InvoiceUpdateException;
use PHPUnit\Framework\TestCase;

class InvoiceUpdateExceptionTest extends TestCase
{

  public function testDefaultApiCode()
  {
    $exception = $this->createClassObject();
    
    $this->assertEquals('000000', $exception->getApiCode());
  }

  public function testInstanceOf()
  {
    $exception = $this->createClassObject();
    $this->assertInstanceOf(InvoiceUpdateException::class, $exception);
  }

  public function testDefaultMessage()
  {
    $exception = $this->createClassObject();
    
    $this->assertEquals(
      'BITPAY-INVOICE-UPDATE: Failed to update invoice-> ',
      $exception->getMessage()
    );
  }

  public function testDefaultCode()
  {
    $exception = $this->createClassObject();
    
    $this->assertEquals(104, $exception->getCode());
  }

  public function testGetApiCode()
  {
    $exception = new InvoiceUpdateException(
      'My test message',
      104,
      null,
      'CUSTOM-API-CODE'
    );

    $this->assertEquals('CUSTOM-API-CODE', $exception->getApiCode());
  }

  private function createClassObject()
  {
    return new InvoiceUpdateException();
  }
}